/*
 * Decompiled with CFR 0.152.
 */
package com.axinom.wowza;

import com.wowza.util.BufferUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

class AxinomIntegrationUtilities {
    AxinomIntegrationUtilities() {
    }

    static String bigEndianGuidHexToGuidString(String input) {
        return UUID.fromString(input.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5")).toString();
    }

    static String removeJsonBracketsAndSeparators(String input) {
        String clearedOutputAsString = input.replace("{", "").replace("}", "").replace("[", "").replace("]", "").replace("\"", "");
        return clearedOutputAsString;
    }

    static String hexToBase64(String inputAsHex) throws UnsupportedEncodingException {
        byte[] decodedHex = BufferUtils.decodeHexString((String)inputAsHex);
        byte[] encodedHexAs64 = Base64.encodeBase64((byte[])decodedHex);
        return new String(encodedHexAs64, "UTF-8");
    }

    static boolean isUrlFormatValid(String serviceUrl) {
        try {
            new URL(serviceUrl).toURI();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static String stringToBase64(String inputAsString) throws UnsupportedEncodingException {
        byte[] base64Bytes = Base64.encodeBase64((byte[])inputAsString.getBytes());
        return new String(base64Bytes, "UTF-8");
    }
}

